/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.util.screenshot;

import club.sk1er.patcher.Patcher;
import club.sk1er.patcher.config.PatcherConfig;
import club.sk1er.patcher.render.ScreenshotPreview;
import club.sk1er.patcher.tasks.UploadScreenshotTask;
import club.sk1er.patcher.util.chat.ChatUtilities;
import gg.essential.api.commands.Command;
import gg.essential.api.commands.DefaultHandler;
import gg.essential.api.utils.Multithreading;
import gg.essential.universal.ChatColor;
import gg.essential.universal.UDesktop;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import org.jetbrains.annotations.NotNull;

public class AsyncScreenshots
implements Runnable {
    public static final String prefix = ChatUtilities.translate("&e[Patcher] &r");
    private static BufferedImage image;
    private static File screenshot;
    private final int width;
    private final int height;
    private final int[] pixelValues;
    private final Minecraft mc = Minecraft.func_71410_x();
    private final File screenshotDirectory;

    public AsyncScreenshots(int width, int height, int[] pixelValues, File screenshotDirectory) {
        this.width = width;
        this.height = height;
        this.pixelValues = pixelValues;
        this.screenshotDirectory = screenshotDirectory;
    }

    private static File getTimestampedPNGFileForDirectory(File gameDirectory) {
        File screenshot;
        String dateFormatting = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date());
        int screenshotCount = 1;
        while ((screenshot = new File(gameDirectory, dateFormatting + (screenshotCount == 1 ? "" : "_" + screenshotCount) + ".png")).exists()) {
            ++screenshotCount;
        }
        return screenshot;
    }

    @Override
    public void run() {
        this.processPixelValues(this.pixelValues, this.width, this.height);
        screenshot = AsyncScreenshots.getTimestampedPNGFileForDirectory(this.screenshotDirectory);
        try {
            image = new BufferedImage(this.width, this.height, 1);
            image.setRGB(0, 0, this.width, this.height, this.pixelValues, 0, this.width);
            ImageIO.write((RenderedImage)image, "png", screenshot);
            if (!PatcherConfig.screenshotNoFeedback) {
                this.sendChatMessages(screenshot);
            }
            if (PatcherConfig.screenshotPreview) {
                ScreenshotPreview.INSTANCE.newCapture(image);
            }
            if (PatcherConfig.autoCopyScreenshot) {
                CopyScreenshot.copyScreenshot(this.mc.field_71439_g != null);
            }
        }
        catch (Exception e) {
            ChatUtilities.sendNotification("Screenshot Manager", "Failed to capture screenshot. " + e.getMessage());
            Patcher.instance.getLogger().error("Failed to capture screenshot.", (Throwable)e);
        }
    }

    private void sendChatMessages(File screenshot) throws IOException {
        boolean compact = PatcherConfig.compactScreenshotResponse;
        ChatComponentText chatComponent = !compact ? new ChatComponentText(prefix + "Screenshot saved to " + screenshot.getName() + " (" + screenshot.length() / 1024L + "kb)") : new ChatComponentText(prefix + "Screenshot saved.");
        ChatComponentText favoriteComponent = new ChatComponentText(ChatColor.YELLOW.toString() + ChatColor.BOLD + (compact ? "FAV" : "FAVORITE"));
        favoriteComponent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/$favorite"));
        favoriteComponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(ChatUtilities.translate("&7This will save the screenshot to a new folder called\n&afavorite_screenshots &7in your Minecraft directory.\n&cThis cannot be done once a new screenshot is taken."))));
        ChatComponentText deleteComponent = new ChatComponentText(ChatColor.RED.toString() + ChatColor.BOLD + (compact ? "DEL" : "DELETE"));
        deleteComponent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/$delete"));
        deleteComponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(ChatUtilities.translate("&7This will delete the screenshot from your screenshots folder.\n&cThis is not recoverable and cannot be deleted once a\n&cnew screenshot is taken or made favorite."))));
        ChatComponentText imgurComponent = new ChatComponentText(ChatColor.GREEN.toString() + ChatColor.BOLD + (compact ? "UPL" : "UPLOAD"));
        imgurComponent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/$upload"));
        imgurComponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(ChatUtilities.translate("&7Upload the screenshot to Imgur, an image hosting website.\n&cThis cannot be uploaded once a new screenshot\n&cis taken, made favorite, or deleted."))));
        ChatComponentText copyComponent = new ChatComponentText(ChatColor.AQUA.toString() + ChatColor.BOLD + (compact ? "CPY" : "COPY"));
        copyComponent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/$copyss"));
        copyComponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(ChatUtilities.translate("&7Copy this image to your system clipboard.\n&cThis cannot be copied once a new screenshot\n&cis taken, made favorite, or deleted."))));
        ChatComponentText folderComponent = new ChatComponentText(ChatColor.BLUE.toString() + ChatColor.BOLD + (compact ? "DIR" : "FOLDER"));
        folderComponent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, this.screenshotDirectory.getCanonicalPath()));
        folderComponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(ChatUtilities.translate("&7Open your screenshots folder."))));
        ChatComponentText controlsMessage = new ChatComponentText("");
        if (PatcherConfig.favoriteScreenshot) {
            controlsMessage.func_150257_a((IChatComponent)favoriteComponent);
        }
        if (PatcherConfig.deleteScreenshot) {
            controlsMessage.func_150258_a(" ").func_150257_a((IChatComponent)deleteComponent);
        }
        if (PatcherConfig.uploadScreenshot) {
            controlsMessage.func_150258_a(" ").func_150257_a((IChatComponent)imgurComponent);
        }
        if (PatcherConfig.copyScreenshot) {
            controlsMessage.func_150258_a(" ").func_150257_a((IChatComponent)copyComponent);
        }
        if (PatcherConfig.openScreenshotsFolder) {
            controlsMessage.func_150258_a(" ").func_150257_a((IChatComponent)folderComponent);
        }
        GuiNewChat chat = this.mc.field_71456_v.func_146158_b();
        chat.func_146227_a((IChatComponent)chatComponent);
        chat.func_146234_a((IChatComponent)controlsMessage, 33000);
    }

    private void processPixelValues(int[] pixels, int displayWidth, int displayHeight) {
        int[] xValues = new int[displayWidth];
        int yValues = displayHeight >> 1;
        for (int val = 0; val < yValues; ++val) {
            System.arraycopy(pixels, val * displayWidth, xValues, 0, displayWidth);
            System.arraycopy(pixels, (displayHeight - 1 - val) * displayWidth, pixels, val * displayWidth, displayWidth);
            System.arraycopy(xValues, 0, pixels, (displayHeight - 1 - val) * displayWidth, displayWidth);
        }
    }

    static class ImageSelection
    implements Transferable {
        private final Image image;

        ImageSelection(Image image) {
            this.image = image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.imageFlavor == flavor;
        }

        @Override
        @NotNull
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (DataFlavor.imageFlavor != flavor) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.image;
        }
    }

    public static class CopyScreenshot
    extends Command {
        public CopyScreenshot() {
            super("$copyss", true, true);
        }

        @DefaultHandler
        public void handle() {
            try {
                CopyScreenshot.copyScreenshot(true);
            }
            catch (HeadlessException e) {
                ChatUtilities.sendNotification("Screenshot Manager", "&cFailed to copy screenshot to clipboard.");
                Patcher.instance.getLogger().error("Failed to copy screenshot to clipboard.", (Throwable)e);
            }
        }

        public static void copyScreenshot(boolean message) throws HeadlessException {
            ImageSelection sel = new ImageSelection(image);
            Multithreading.runAsync(() -> Toolkit.getDefaultToolkit().getSystemClipboard().setContents(sel, null));
            if (message) {
                ChatUtilities.sendMessage("&aScreenshot has been copied to your clipboard.");
            }
        }
    }

    public static class UploadScreenshot
    extends Command {
        public UploadScreenshot() {
            super("$upload", true, true);
        }

        @DefaultHandler
        public void handle() {
            UploadScreenshotTask.INSTANCE.execute(screenshot);
        }
    }

    public static class DeleteScreenshot
    extends Command {
        public DeleteScreenshot() {
            super("$delete", true, true);
        }

        @DefaultHandler
        public void handle() {
            try {
                if (screenshot.exists() && screenshot.delete()) {
                    ChatUtilities.sendNotification("Screenshot Manager", "&c" + screenshot.getName() + " has been deleted.");
                    screenshot = null;
                } else {
                    ChatUtilities.sendNotification("Screenshot Manager", "&cCouldn't find " + screenshot.getName());
                }
            }
            catch (NullPointerException e) {
                ChatUtilities.sendNotification("Screenshot Manager", "&cFailed to delete screenshot, maybe the file was moved/deleted?");
            }
        }
    }

    public static class FavoriteScreenshot
    extends Command {
        public FavoriteScreenshot() {
            super("$favorite", true, true);
        }

        @DefaultHandler
        public void handle() {
            try {
                File favoritedScreenshots = AsyncScreenshots.getTimestampedPNGFileForDirectory(new File("./favorite_screenshots"));
                screenshot.delete();
                if (!favoritedScreenshots.exists()) {
                    favoritedScreenshots.mkdirs();
                }
                ImageIO.write((RenderedImage)image, "png", favoritedScreenshots);
                ChatUtilities.sendNotification("Screenshot Manager", "&e" + screenshot.getName() + " has been favorited.");
            }
            catch (Throwable e) {
                ChatUtilities.sendNotification("Screenshot Manager", "&cFailed to favorite screenshot, maybe the file was moved/deleted?");
            }
        }
    }

    public static class ScreenshotsFolder
    extends Command {
        public ScreenshotsFolder() {
            super("$openfolder", true, true);
        }

        @DefaultHandler
        public void handle() {
            try {
                UDesktop.open((File)new File("./screenshots"));
            }
            catch (Exception e) {
                ChatUtilities.sendMessage("Unfortunately, we were unable to open the screenshots folder. Contact the support Discord at https://sk1er.club/support if this issue persists.");
            }
        }
    }
}

